<?php
require_once '../includes/db.php';
require_once '../includes/functions.php';
if (!isLoggedIn()) redirect('login.php');
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Admin Dashboard</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">

<?php include 'nav.php'; ?>

<div class="container py-5">

  <div class="text-center mb-5">
    <h2 class="fw-bold text-primary">Welcome to Admin Dashboard</h2>
    <p class="text-muted">Manage your website settings, users, and system controls from here.</p>
  </div>

  <div class="row g-4 justify-content-center">

    <div class="col-md-4 col-sm-6">
      <div class="card border-0 shadow-sm h-100 text-center p-4">
        <div class="mb-3 text-primary">
          <svg xmlns="http://www.w3.org/2000/svg" width="38" height="38" fill="none" stroke="currentColor" stroke-width="2"
               stroke-linecap="round" stroke-linejoin="round">
            <circle cx="12" cy="12" r="3" />
            <path d="M19.4 15a1.65 1.65 0 0 0 .33 1.82l.06.06a2 2 0 0 1 0 2.83 2 2 0 0 1-2.83 0l-.06-.06a1.65 
              1.65 0 0 0-1.82-.33 1.65 1.65 0 0 0-1 1.51V21a2 2 0 0 1-4 0v-.09a1.65 
              1.65 0 0 0-1-1.51 1.65 1.65 0 0 0-1.82.33l-.06.06a2 
              2 0 0 1-2.83 0 2 2 0 0 1 0-2.83l.06-.06a1.65 
              1.65 0 0 0 .33-1.82 1.65 1.65 0 0 0-1.51-1H3a2 
              2 0 0 1 0-4h.09a1.65 
              1.65 0 0 0 1.51-1 1.65 
              1.65 0 0 0-.33-1.82l-.06-.06a2 
              2 0 0 1 0-2.83 2 2 0 0 1 
              2.83 0l.06.06a1.65 
              1.65 0 0 0 1.82.33H9a1.65 
              1.65 0 0 0 1-1.51V3a2 
              2 0 0 1 4 0v.09a1.65 
              1.65 0 0 0 1 1.51 1.65 
              1.65 0 0 0 1.82-.33l.06-.06a2 
              2 0 0 1 2.83 0 2 2 0 0 1 
              0 2.83l-.06.06a1.65 
              1.65 0 0 0-.33 1.82V9c0 
              .65.26 1.28.73 1.75.47.47 
              1.1.73 1.75.73z" />
          </svg>
        </div>
        <h5 class="fw-semibold mb-2">App Settings</h5>
        <p class="text-muted small">Update site title, logo, and system configurations.</p>
        <a href="settings.php" class="btn btn-outline-primary w-100">Manage Settings</a>
      </div>
    </div>

    <div class="col-md-4 col-sm-6">
      <div class="card border-0 shadow-sm h-100 text-center p-4">
        <div class="mb-3 text-secondary">
          <svg xmlns="http://www.w3.org/2000/svg" width="38" height="38" fill="none" stroke="currentColor" stroke-width="2"
               stroke-linecap="round" stroke-linejoin="round">
            <rect x="3" y="11" width="18" height="11" rx="2" ry="2" />
            <path d="M7 11V7a5 5 0 0 1 10 0v4" />
          </svg>
        </div>
        <h5 class="fw-semibold mb-2">Change Password</h5>
        <p class="text-muted small">Keep your account secure by updating your password regularly.</p>
        <a href="change_password.php" class="btn btn-outline-secondary w-100">Change Password</a>
      </div>
    </div>

  </div>

</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
