document.querySelectorAll('input[type="file"]').forEach(input => {
  input.addEventListener('change', function() {
    if (this.files.length > 0) {
      let label = this.previousElementSibling;
      if (label && label.tagName.toLowerCase() === 'label') {
        label.textContent = "Selected: " + this.files[0].name;
      }
    }
  });
});

window.addEventListener('DOMContentLoaded', () => {
  const alerts = document.querySelectorAll('.alert');
  setTimeout(() => {
    alerts.forEach(a => a.classList.add('fade'));
  }, 3000);
});

document.querySelectorAll('a[href^="#"]').forEach(anchor => {
  anchor.addEventListener('click', function(e) {
    e.preventDefault();
    document.querySelector(this.getAttribute('href')).scrollIntoView({
      behavior: 'smooth'
    });
  });
});
